/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.PmStationDto;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;

public class PmStationDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE  = "UM_STATION";
	public static final String KEY_1 = "STATION_CODE";	//R[h
	
	// 
	public static final String COL_STATION_CODE     = "STATION_CODE"    ;	// R[h
	public static final String COL_STATION_NAME     = "STATION_NAME"    ;	// 
	public static final String COL_STATION_ABB_NAME = "STATION_ABB_NAME";	// 
	public static final String COL_BUSINESS_TYPE    = "BUSINESS_TYPE"   ;	// Ɩ`
	public static final String COL_CALENDAR_TYPE    = "CALENDAR_TYPE"   ;	// J_[敪
	public static final String COL_EFFORT_TYPE      = "EFFORT_TYPE"     ;	// ʗ敪
	public static final String COL_BELONG_CODE      = "BELONG_CODE"     ;	// ʏR[h
	public static final String COL_DELETE_FLAG      = "DELETE_FLAG"     ;	// 폜tO
	
	/**
	 * RXgN^
	 */
	public PmStationDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PmStationDto> mappingAll() throws SQLException {
		List<PmStationDto> all = new ArrayList<PmStationDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PmStationDto UM_STATIONR[h
	 * @throws SQLException
	 */
	private PmStationDto mapping() throws SQLException {
		PmStationDto dto = new PmStationDto();
		dto.setStationCode   (rs.getString(COL_STATION_CODE    ));	// R[h
		dto.setStationName   (rs.getString(COL_STATION_NAME    ));	// 
		dto.setStationAbbName(rs.getString(COL_STATION_ABB_NAME));	// 
		dto.setBusinessType  (rs.getString(COL_BUSINESS_TYPE   ));	// Ɩ`
		dto.setCalendarType  (rs.getString(COL_CALENDAR_TYPE   ));	// J_[敪
		dto.setEffortType    (rs.getString(COL_EFFORT_TYPE     ));	// ʗ敪
		dto.setBelongCode    (rs.getString(COL_BELONG_CODE     ));	// ʏR[h
		dto.setDeleteFlag    (rs.getInt   (COL_DELETE_FLAG     ));	// 폜tO
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmStationDto> findAll(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PmStationDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Lf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmStationDto> findNotDeleted(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG + " = " + MospConst.DELETE_FLAG_OFF + " ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<PmStationDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Lf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmStationDto> findAvailable(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_STATION_CODE + " IN (");
			sb.append(getBelongedStationQuery());
			sb.append(") ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<PmStationDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p\f[^擾
	 * @param kCode       ЈR[h
	 * @param stationCode R[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmStationDto> findAvailable(
			String kCode,
			String stationCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_STATION_CODE + " IN (");
			sb.append(getBelongedStationQuery());
			sb.append(") AND (");
			sb.append(COL_STATION_CODE + " IN (");
			sb.append(getStationQuery());
			sb.append(") OR ");
			sb.append(COL_STATION_CODE + " IN (");
			sb.append(PsAvailableStaDao.getAvailableStationQuery());
			sb.append(")) ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, stationCode);
			setParam(index++, kCode);
			executeQuery();
			List<PmStationDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p\f[^擾
	 * @param kCode       ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmStationDto> findAvailable(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_STATION_CODE + " IN (");
			sb.append(PsAvailableStaDao.getAvailableStationQuery());
			sb.append(") ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			List<PmStationDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * (GA)f[^擾
	 * @param kCode       ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmStationDto> findExceptArea(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_STATION_CODE + " NOT IN (");
			sb.append(getAreaStationQuery());
			sb.append(") AND ");
			sb.append(COL_DELETE_FLAG + " = " + MospConst.DELETE_FLAG_OFF + " ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<PmStationDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param stationCode R[h(L[)
	 * @return PmStationDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmStationDto findForKey(
			String  stationCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, stationCode);
			executeQuery();
			PmStationDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param stationCode R[h(L[)
	 * @return PmStationDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmStationDto findForUpdate(
			String stationCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, stationCode);
			executeQuery();
			PmStationDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param stationCode R[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmStationDto> findForCondition(
			String stationCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_STATION_CODE);
		sb.append(" LIKE ? AND ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, stationCode);
			executeQuery();
			List<PmStationDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	/**
	 * ɂf[^擾
	 * @param stationCode R[h
	 * @param stationName 
	 * @param deleteFlag   폜tO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmStationDto> findForCondition(
			String stationCode,
			String stationName,
			String deleteFlag
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_STATION_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_STATION_NAME);
		sb.append(" LIKE ?  ");
		if ( !deleteFlag.equals("") ){
			sb.append(" AND  ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ?  ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, stationCode + "%"  );
			setParam(index++, "%" + stationName + "%" );
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			List<PmStationDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PmStationDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PmStationDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getStationCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PmStationDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getStationCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PmStationDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getStationCode   ());	// R[h
		setParam(index++, dto.getStationName   ());	// 
		setParam(index++, dto.getStationAbbName());	// ƕ
		setParam(index++, dto.getBusinessType  ());	// Ɩ`
		setParam(index++, dto.getCalendarType  ());	// J_[敪
		setParam(index++, dto.getEffortType    ());	// ʗ敪
		setParam(index++, dto.getBelongCode    ());	// ʏR[h
		setParam(index++, dto.getDeleteFlag    ());	// 폜tO
		setCommonParams(isInsert);
	}
	
	/**
	 * (ʏ)R[h擾SQL
	 * @return (ʏ)R[h擾SQL
	 */
	public static final String getStationQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_STATION_CODE + " ");
		sb.append("FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_DELETE_FLAG + " = " + MospConst.DELETE_FLAG_OFF + " ");
		sb.append("AND ");
		sb.append(COL_BELONG_CODE + " IN (");
		sb.append("SELECT " + COL_BELONG_CODE + " ");
		sb.append("FROM " + TABLE + " ");
		sb.append("WHERE " + COL_STATION_CODE + " = ? ");
		sb.append(") ");
		return sb.toString();
	}

	/**
	 * (ʏ)R[h擾SQL
	 * @return (ʏ)R[h擾SQL
	 */
	public static final String getBelongedStationQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_STATION_CODE + " ");
		sb.append("FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_STATION_CODE + " = " + COL_BELONG_CODE + " ");
		sb.append("AND ");
		sb.append(COL_DELETE_FLAG + " = " + MospConst.DELETE_FLAG_OFF + " ");
		return sb.toString();
	}
	
	/**
	 * ʏR[h擾SQL
	 * @return ʏR[h擾SQL
	 */
	private static final String getAreaStationQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_BELONG_CODE + " ");
		sb.append("FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_STATION_CODE + " <> " + COL_BELONG_CODE + " ");
		return sb.toString();
	}
	
}
